/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS;

import jpcsp.HLE.TPointer;
import jpcsp.HLE.VFS.AbstractProxyVirtualFile;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.util.Utilities;

public class BufferedVirtualFile
extends AbstractProxyVirtualFile {
    private byte[] buffer;
    private int bufferIndex;
    private int bufferLength;

    protected BufferedVirtualFile() {
    }

    public BufferedVirtualFile(IVirtualFile vFile, int bufferSize) {
        this.setBufferedVirtualFile(vFile, bufferSize);
    }

    protected void setBufferedVirtualFile(IVirtualFile vFile, int bufferSize) {
        this.setProxyVirtualFile(vFile);
        this.buffer = new byte[bufferSize];
        this.bufferIndex = 0;
        this.bufferLength = 0;
    }

    private void copyFromBuffer(int outputAddr, int length) {
        if (length <= 0) {
            return;
        }
        Utilities.writeBytes(outputAddr, length, this.buffer, this.bufferIndex);
        this.bufferIndex += length;
    }

    private void copyFromBuffer(byte[] output, int offset, int length) {
        if (length <= 0) {
            return;
        }
        System.arraycopy(this.buffer, this.bufferIndex, output, offset, length);
        this.bufferIndex += length;
    }

    private void checkPopulateBuffer() {
        if (this.bufferIndex < this.bufferLength) {
            return;
        }
        if (this.bufferLength > 0) {
            this.bufferIndex = 0;
        }
        this.bufferLength = this.vFile.ioRead(this.buffer, 0, this.buffer.length);
    }

    @Override
    public int ioRead(TPointer outputPointer, int outputLength) {
        int readLength;
        int length;
        if (this.bufferLength < 0) {
            return this.bufferLength;
        }
        for (readLength = 0; this.bufferLength >= 0 && readLength < outputLength; readLength += length) {
            this.checkPopulateBuffer();
            length = Math.min(this.bufferLength - this.bufferIndex, outputLength - readLength);
            this.copyFromBuffer(outputPointer.getAddress() + readLength, length);
        }
        return readLength;
    }

    @Override
    public int ioRead(byte[] outputBuffer, int outputOffset, int outputLength) {
        int readLength;
        int length;
        if (this.bufferLength < 0) {
            return this.bufferLength;
        }
        for (readLength = 0; this.bufferLength >= 0 && readLength < outputLength; readLength += length) {
            this.checkPopulateBuffer();
            length = Math.min(this.bufferLength - this.bufferIndex, outputLength - readLength);
            this.copyFromBuffer(outputBuffer, outputOffset + readLength, length);
        }
        return readLength;
    }

    @Override
    public int ioWrite(TPointer inputPointer, int inputLength) {
        return -1;
    }

    @Override
    public int ioWrite(byte[] inputBuffer, int inputOffset, int inputLength) {
        return -1;
    }

    @Override
    public long ioLseek(long offset) {
        long virtualFileOffset = offset / (long)this.buffer.length * (long)this.buffer.length;
        long result = this.vFile.ioLseek(virtualFileOffset);
        if (result == -1L) {
            return result;
        }
        this.bufferLength = 0;
        this.bufferIndex = 0;
        if (offset > virtualFileOffset) {
            this.bufferIndex = (int)(offset - virtualFileOffset);
        }
        return offset;
    }

    @Override
    public long getPosition() {
        if (this.bufferLength <= 0) {
            return this.vFile.getPosition();
        }
        return this.vFile.getPosition() - (long)this.bufferLength + (long)this.bufferIndex;
    }

    @Override
    public IVirtualFile duplicate() {
        IVirtualFile vFileDuplicate = this.vFile.duplicate();
        if (vFileDuplicate == null) {
            return null;
        }
        BufferedVirtualFile dup = new BufferedVirtualFile(vFileDuplicate, this.buffer.length);
        dup.ioLseek(this.getPosition());
        return dup;
    }
}

